# Отчет по доступам и обеспечению безопасности расширения "Проверка Исков"

## 1. Описание расширения

Расширение **"Проверка Исков"** предназначено для получения данных по искам из судебного кабинета и взаимодействия с государственными порталами. Оно автоматически собирает информацию о судебных делах, исполнительных производствах и обеспечивает удобство при работе с соответствующими сайтами.

## 2. Необходимые разрешения и доступы

Для корректной работы расширения требуются определенные разрешения и доступы, которые указаны в файле `manifest.json`.

### 2.1. Разрешения (`permissions`)

- **`storage`**: Позволяет расширению сохранять и получать данные из локального хранилища браузера. Это необходимо для хранения пользовательских настроек и промежуточных данных.
- **`activeTab`**: Дает возможность взаимодействовать с темой вкладкой, на которой активно работает пользователь. Используется для выполнения скриптов на текущей странице.
- **`downloads`**: Позволяет управлять загрузками файлов, что необходимо для сохранения документов и отчетов на компьютер пользователя.
- **`cookies`**: Доступ к cookies необходим для поддержки сессий и авторизации на целевых сайтах.
- **`tabs`**: Позволяет управлять вкладками браузера, открывать новые, обновлять существующие и отслеживать изменения.
- **`scripting`**: Используется для выполнения скриптов в контексте веб-страниц, что необходимо для взаимодействия с содержимым страниц.

### 2.2. Разрешения на доступ к сайтам (`host_permissions`)

- **`https://office.sud.kz/*`**: Доступ к судебному кабинету для получения информации о судебных делах.
- **`https://aisoip.adilet.gov.kz/*`**: Доступ к порталу исполнительного производства для получения сведений о должниках.
- **`http://93.183.80.88:8000/*`**: Доступ к локальному серверу или API для дополнительной обработки данных (предположительно внутренний ресурс).

### 2.3. Контентные скрипты (`content_scripts`)

Расширение внедряет скрипты в определенные страницы для взаимодействия с их содержимым:

- **`https://office.sud.kz/form/proceedings/myCases.xhtml`**: Скрипт `noThrottle.js` для оптимизации работы страницы.
- **`https://office.sud.kz/*`**: Скрипты `isLogged.js` и `contentScript.js` для проверки авторизации пользователя и автоматизации действий.
- **`http://93.183.80.88:8000/*`**: Скрипт `content.js` для взаимодействия с внутренним ресурсом.

### 2.4. Доступные веб-ресурсы (`web_accessible_resources`)

- **`sound.mp3` и `xlsx.full.min.js`**: Используются на сайтах `https://office.sud.kz/*` для звуковых уведомлений и работы с документами в формате Excel.
- **`content.js`**: Доступен на сайтах `https://office.sud.kz/*` и `http://93.183.80.88:8000/*` для обеспечения дополнительной функциональности.
- **`xlsx.full.min.js`**: Доступен на всех сайтах (`<all_urls>`) для обработки Excel документов.

## 3. Меры безопасности

### 3.1. Авторизация и аутентификация

- **Регулярная авторизация**: Расширение использует стандартные механизмы авторизации на целевых сайтах, не обходя и не нарушая их протоколы безопасности.
- **Проверка авторизации**: Скрипт `isLogged.js` проверяет, авторизован ли пользователь на сайте, и при необходимости инициирует процессы авторизации.

### 3.2. Шифрование данных

- **Шифрование пользовательской информации**: Все пользовательские данные, включая информацию об учетных записях и получаемые данные из сайтов, шифруются перед сохранением и передачей.
- **Безопасное хранение**: Данные сохраняются с использованием `chrome.storage.local`, что обеспечивает изолированность и защиту от внешнего доступа.

### 3.3. Обработка персональных данных

- **Конфиденциальность**: При работе с персональной информацией (например, ИИН), расширение обеспечивает ее безопасность и не передает данные третьим лицам.
- **Минимизация данных**: Собираются только необходимые данные для выполнения задач расширения, без избыточного сбора информации.

### 3.4. Безопасность сетевых запросов

- **Защита от атак типа "человек посередине"**: Используются безопасные протоколы связи (`https`) при взаимодействии с внешними сайтами.
- **Проверка сертификатов**: Взаимодействие происходит только с доверенными ресурсами с валидными SSL-сертификатами.

### 3.5. Управление загрузками

- **Контроль загружаемых файлов**: Расширение загружает файлы только с доверенных источников и сохраняет их в установленные директории.
- **Обработка ошибок**: Реализована обработка ошибок при загрузке и сохранении файлов, что предотвращает возможные сбои и потери данных.

